/**
* \file: socket_server.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_APP_IFACE_SOCKET_SERVER_H
#define AAM_APP_IFACE_SOCKET_SERVER_H

#include <stdbool.h>

#include "automounter_types.h"
#include "ipc/info_messages.h"
#include "ipc/message_sendr.h"

typedef struct connection_ctx_t connection_ctx_t;

typedef void (*socket_server_handle_msg_callback_t)(connection_ctx_t *connection);

message_buffer_t *socket_server_get_empty_msg_buffer(void);

error_code_t socket_server_send_msg(message_buffer_t *msg_buffer, connection_ctx_t *connection);

void socket_server_broadcast_msg(message_buffer_t *msg_buffer, event_mask_t event);

error_code_t socket_server_init(socket_server_handle_msg_callback_t msg_callback_func);

void socket_server_deinit(void);

void socket_server_set_connection_appinfo(connection_ctx_t *ctx, const char *app_identifier, event_mask_t event_mask);

const char *socket_server_get_connection_appidentifier(connection_ctx_t *ctx);

event_mask_t socket_server_get_connection_event_mask(connection_ctx_t *ctx);

bool socket_server_is_ctx_registered_for_event(connection_ctx_t *ctx, event_mask_t event);

message_buffer_t *socket_server_get_receiver_buffer(connection_ctx_t *ctx);

#endif

